/*
** filterlib.h - written in milano by vesely on 27sep2003
** utilities for forking global filters for courier-mta
*/
/*
** Copyright (c) 1999, 2000, 2001, 2002, 2003 Alessandro Vesely
This file is part of avfilter

avfilter is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

avfilter is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License version 3
along with avfilter.  If not, see <http://www.gnu.org/licenses/>.

*/

#if !defined(FILTERLIB_H_INCLUDED)

struct filter_lib_struct;
typedef struct filter_lib_struct fl_parm;

typedef void (*fl_callback)(fl_parm*);
typedef struct fl_init_parm
{
	fl_callback
		filter_fn, // filter function
		init_complete, // called once before main loop
		on_sighup, on_sigusr1, on_sigusr2, // possibly null sig handlers
		test_fn1, test_fn2, test_fn3, test_fn4; // test functions
} fl_init_parm;

int fl_main(fl_init_parm const*, void *parm,
	int argc, char*argv[], int all_mode, int verbose);

/* utilities for callback function */
void *fl_get_parm(fl_parm*);
void fl_set_parm(fl_parm *, void* parm);
void fl_set_verbose(fl_parm*, int);
int fl_get_verbose(fl_parm*);
typedef enum fl_test_mode { fl_no_test,
	fl_testing, fl_batch_test } fl_test_mode;
fl_test_mode fl_get_test_mode(fl_parm*);

/* utilities only for filter function */
FILE* fl_get_file(fl_parm*);
char const* fl_get_filename(fl_parm*);
FILE* fl_get_write_file(fl_parm*);
int fl_commit_write(fl_parm *fl);
void fl_rollback_write(fl_parm *fl);
char *fl_get_sender(fl_parm *fl);
char *fl_get_authsender(fl_parm *fl);
typedef int (*fl_rcpt_callback)(void *parm, char const *rcpt);
int rcpt_iterate(fl_parm *fl, fl_rcpt_callback);
int fl_drop_message(fl_parm*);
void fl_pass_message(fl_parm*, char const *);
void fl_alarm(unsigned seconds);
int fl_keep_running(void);
// int fl_rewrite_message(fl_parm*);
// int fl_is_pass_signed(fl_parm*, char const *header, size_t header_length);

#define FILTERLIB_H_INCLUDED 1
#endif
