/*
** tfork.c - written in milano by vesely on 19 feb 2004
** test what does anti virus engine after fork
*/
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <assert.h>
#include <errno.h>
#include <ctype.h>
#include <limits.h>

#include <sys/types.h>
#include <sys/wait.h>
#if HAVE_SYS_STAT_H
#include <sys/stat.h>
#endif
#include <signal.h>
#if HAVE_FCNTL_H
#include <fcntl.h>
#endif

#include <clamav.h>

// static CISavi3 *pSAVI;
static struct cl_engine *clamav;

static int live_children = 0;

static void child_reaper(int sig)
{
	int status;
	(void)sig;
	
	while (waitpid(-1, &status, WNOHANG) > 0)
	{
		--live_children;
	}
}

static void child_wait_init(void)
{
	struct sigaction act;
	memset(&act, 0, sizeof act);
	sigemptyset(&act.sa_mask);
	
	act.sa_flags = SA_NOCLDSTOP;
	act.sa_handler = child_reaper;
	sigaction(SIGCHLD, &act, NULL);
}

static long long get_test_option(void)
{
	int rtc = 0;
	long long ll = cl_engine_get_num(clamav, CL_ENGINE_KEEPTMP, &rtc);
	if (rtc != CL_SUCCESS)
	{
		fprintf(stderr,
			"tfork: cannot get test option: %s\n",
			cl_strerror(rtc));
		return -1;
	}
	return ll;
}

static int set_test_option(long long ll)
{
	int rtc = cl_engine_set_num(clamav, CL_ENGINE_KEEPTMP, ll);

	if (rtc != CL_SUCCESS)
	{
		fprintf(stderr,
			"tfork: cannot get test option: %s\n",
			cl_strerror(rtc));
		return 1;
	}

	return 0;
}

static void change_test_option(char const *whoami)
{
	long long value = get_test_option();
	if (value == 0 || value == 1)
	{
		long long new_value = 1 - value;
		fprintf(stdout,
			"%s: changing option from %lld to %lld\n",
				whoami, value, new_value);
		if (set_test_option(new_value) == 0)
		{
			value = get_test_option();
			if (value >= 0)
				fprintf(stdout,
					"%s: now option is %lld\n", whoami, value);
		}
		fflush(stdout);
	}
	else
		fprintf(stderr, "tfork: unexpected value %lld\n", value);
}

static void check_test_option(char const *whoami)
{
	long long value = get_test_option();
	if (value == 0 || value == 1)
	{
		if (value >= 0)
			fprintf(stdout,
				"%s: option is %lld\n",
					whoami, value);
		fflush(stdout);
	}
	else
		fprintf(stderr, "tfork: unexpected value %lld\n", value);
}

static void do_test(void)
{
	int ctl[2];
	pid_t pid;
	char buf[4];

	if (pipe(ctl))
	{
		perror("pipe");
		return;
	}
	
	pid = fork();
	if (pid < 0)
	{
		perror("fork");
		return;
	}
	
	if (pid == 0) // child
	{
		int rtc;
		close(ctl[1]);
		rtc = read(ctl[0], buf, 1); // wait for parent
		if (rtc == 1)
			change_test_option("child");
		else
			perror("read ctl");

		cl_engine_free(clamav);
		exit(0);
	}
	else // parent
	{
		live_children = 1;
		close(ctl[0]);
		check_test_option("parent");
		if (write(ctl[1], buf, 1) != 1)
			perror("write ctl");
		while (live_children > 0)
			sleep(1);
		check_test_option("parent");
	}
}

static void initialize_clamav(int verbose)
{
	int rtc = cl_init(CL_INIT_DEFAULT);
	if (rtc == CL_SUCCESS)
	{
		struct cl_engine *p = cl_engine_new();
		if (p)
		{
			unsigned int sigs = 0;
			const char *dbdir = cl_retdbdir();
			rtc = CL_SUCCESS; // cl_load(dbdir, p, &sigs, CL_DB_STDOPT);
			if (verbose)
			{
				printf("%u signatures loaded from %s: %s\n",
					sigs, dbdir, cl_strerror(rtc));
				printf("Version %s, F-level %u\n",
					cl_retver(), cl_retflevel());
			}

			if (rtc == CL_SUCCESS)
				rtc = cl_engine_compile(p);

			if (rtc == CL_SUCCESS)
				clamav = p;
			else
				cl_engine_free(p);
		}
	}

	if (rtc != CL_SUCCESS)
		fprintf(stderr, "ERROR: %s\n", cl_strerror(rtc));
}

int main(int argc, char *argv[])
{
	int i;
	int verbose = 0;
	for (i = 1; i < argc; ++i)
		if (strcmp(argv[i], "-v") == 0)
			verbose = 1;

	child_wait_init();
	initialize_clamav(verbose);
	if (clamav)
	{
		do_test();

		cl_engine_free(clamav);
	}

	return 0;
}
