/*
** test vsnprintf
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

void tvsp(unsigned int m, char const *fmt, ...)
{
	char buf[4096];
	va_list stack;
	int rtc;
	
	if (m + 1 >= sizeof buf)
		return;
	
	va_start(stack, fmt);
	memset(buf, 0, sizeof buf);
	rtc = vsnprintf(buf, m, fmt, stack);
	printf("vsnprintf returned %2d, actual length %2zu, \"%s\"\n",
		rtc, strlen(buf), buf);
	va_end(stack);
}

int main(int argc, char *argv[])
{
	int i;
	
	for (i = 1; i < argc; ++i)
	{
		unsigned int m = abs(atoi(argv[i]));
		tvsp(m, "test %2d %#4x %20s", m, m, "end test string");
	}
	return 0;
}
